$(document).ready(function(e) {
    $(document).on('click', '.selection', function(e) {
        $('#selectionsModalTitle').html(loader);
        $('#selectionsModalBody').html(loader);
        let id = $(this).data('id');

        $.ajax({
			url: '/clients/selections/ajax/view-selection.php',
			method: 'GET',
			data: {
				id: id
			},
			success: function (data) {
				console.log(data);

                let response = JSON.parse(data);
                let title = response.title;
                let html = response.html;

                $('#selectionsModalTitle').html(title);
                $('#selectionsModalBody').html(html);

                initObserver();
			},
			error: function (e) {
				console.log(e);
			}
		});
    });

    var selectionsTable = new DataTable('#selectionsDT', {
        // dom: '<"d-flex justify-content-between my-2"<"d-flex me-auto"l><"d-flex ms-auto"f>>',
        layout: {
            topStart: {
                pageLength: {
                    menu: [10, 25, 50, 100],
                    text: '_MENU_'
                }
            },
            topEnd: {
                search: {
                    text: '',
                    placeholder: 'Search'
                }
            },
            bottomStart: null
        },
        pageLength: 50,
        responsive: true,
        // responsive: {
        //     details: {
        //         type: 'column',
        //         target: 0
        //     }
        // },
        // columnDefs: [
        //     { data: null, defaultContent: '', className: 'control', orderable: false, targets: 0, responsivePriority: 1, targets: 0 },
        //     { responsivePriority: 2, targets: 1 },
        //     { responsivePriority: 0, targets: 2 },
        //     { responsivePriority: 3, targets: 3 },
        //     { responsivePriority: 4, targets: 4 },
        //     { responsivePriority: 5, targets: 5 },
        //     { responsivePriority: 6, targets: 6 },
        //     { responsivePriority: 7, targets: 7 },
        //     { responsivePriority: 8, targets: 8 },
        //     { responsivePriority: 9, targets: 9 },
        // ]
    });

    selectionsTable.on('responsive-display', function(e, datatable, row, showHide, update) {
        let node = row.node();
        if ( showHide == true ) {
            initObserver();

            node.style.position = 'sticky';
            node.style.top = '0';
            node.classList.add('bg-body');
        } else {
            node.style.position = '';
            node.style.top = '';
            node.classList.remove('bg-body');
        }
    });

    Fancybox.bind("[data-fancybox]", {
        Toolbar: {
            display: {
                left: ["infobar"],
                middle: [],
                right: ["iterateZoom", "slideshow", "thumbs", "download", "close"],
            },
        },
    });
    
    initObserver();
});